/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.api.scheduler.v2;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import net.impactdev.impactor.api.logging.PluginLogger;
import net.impactdev.impactor.api.scheduler.v2.Scheduler;
import net.kyori.adventure.key.Key;
import org.jetbrains.annotations.NotNull;

public final class Schedulers {
    private static final Map<Key, Scheduler> schedulers = Maps.newHashMap();

    public static void register(@NotNull Key key, @NotNull Scheduler scheduler) {
        schedulers.put(key, scheduler);
    }

    public static Optional<Scheduler> request(@NotNull Key key) {
        Preconditions.checkNotNull((Object)key);
        return Optional.ofNullable(schedulers.get(key));
    }

    public static Scheduler require(@NotNull Key key) {
        Preconditions.checkNotNull((Object)key);
        return (Scheduler)Preconditions.checkNotNull((Object)schedulers.get(key));
    }

    public static void shutdown(PluginLogger logger) {
        schedulers.forEach((key, scheduler) -> {
            logger.info("Shutting down scheduler: " + String.valueOf(key));
            scheduler.shutdown();
        });
    }
}

